/*
Copyright (C) 2009 Pedro Kiefer (pedro@kiefer.com.br)

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

Calendar = Class.create({
   initialize: function (inputId, parameters) {
      
      this.params = $H(parameters);
      
      //properties.each (function (item) {alert (item.toString());});
      
      this.inputId = inputId;
      
      this.bindInput = $(inputId);
      
      this.bindInput.component = this;
      
      this.instanceName = '$(\''+this.inputId+'\').component';
      
      this.initializeParameters();
      
      this.visible = false;
      
      this.createRichInput();
      
      if (this.bindInput.value != '') {
         this.currentDate = this.parseDate (this.bindInput.value, this.datePattern);
         this.setSelectedDate (this.currentDate);
      } else {
         this.currentDate = new Date();
         this.selectedDate = new Date();
      }
      
      this.prepareEvents();
      
      var handler = new Function ('event', this.instanceName +'.toggle();').bindAsEventListener();
      
      Event.observe ($(this.wrapperId + 'ImageBtn'), 'click', handler);
      Event.observe (this.inputId, 'click', handler);

   },
   
   initializeParameters: function () {
      if (this.params.get ('monthLabels')) {
         this.monthLabels = this.params.get ('monthLabels');
      } else {
         this.monthLabels = ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'];
      }
      
      if (this.params.get ('monthLabelsShort')) {
         this.monthLabelsShort = this.params.get ('monthLabelsShort');
      } else {
         this.monthLabelsShort = ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'];
      }
      
      if (this.params.get ('weekDayLabels')) {
         this.weekDayLabels = this.params.get ('weekDayLabels');
      } else {
         this.weekDayLabels = ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sab'];
      }
      
      if (this.params.get ('datePattern')) {
         this.datePattern = this.params.get ('datePattern');
      } else {
         this.datePattern = "dd/MMM/yyyy";
      }
      
      if (this.params.get ('todayLabel')) {
         this.todayLabel = this.params.get ('todayLabel');
      } else {
         this.todayLabel = "Hoje";
      }
      
      if (this.params.get ('closeLabel')) {
         this.closeLabel = this.params.get ('closeLabel');
      } else {
         this.closeLabel = "Fechar";
      }
      
      if (this.params.get ('cleanLabel')) {
         this.cleanLabel = this.params.get ('cleanLabel');
      } else {
         this.cleanLabel = "Limpar";
      }
   },
   
   buildUniqueId: function () {
      var id = 'calendar_' + (Math.ceil(Math.random() * 1000) + Math.ceil(Math.random() * 200));
      
      if ($(id) != undefined) {
         return this.buildUniqueId();
      }
      
      return id;
      
   },
   
   prepareEvents: function () {
      this.eventOnCollapse = this.eventOnCollapse.bindAsEventListener(this);
   },
    
   createRichInput: function () {
      
      this.wrapperId = this.buildUniqueId();
      var div = new Element ('div', {'id': this.wrapperId});
      Element.wrap (this.bindInput, div);
      
      var imageElement = new Element('img', {'src': 'images/cal.gif', 'id': this.wrapperId + 'ImageBtn'})
      
      div.appendChild (imageElement);
      
      var offset = Element.positionedOffset (this.bindInput);
      var width = Element.getWidth (this.bindInput);
      var height = Element.getHeight (this.bindInput);
      
      this.calendarHtml = new Element('div', {'class' : 'calendar_div', 'id': this.wrapperId + 'DatePicker'});
      
      this.calendarHtml.setStyle ( {top:(offset[1] + height)+ 'px', left:(offset[0] + width - 145)+ 'px', border: '1px solid black'});
      
      Element.hide (this.calendarHtml);
      
      div.appendChild (this.calendarHtml);
      
   },
   
   daysInMonth: function (year,month) {
   	return 32 - new Date(year, month, 32).getDate();
   },
   
   getMonthByLabel: function (monthLabel, monthNames) {
      var i=0;
   	while (i<monthNames.length) if (monthNames[i]==monthLabel) return i; else i++;
   },
   
   parseDate: function (dateString, pattern) {
      // Copied from richfaces calendar.js
   	var re = /([.*+?^<>=!:${}()[\]\/\\])/g;
   	var monthNamesStr = this.monthLabels.join('|').replace(re, '\\$1');
   	var monthNamesShortStr = this.monthLabelsShort.join('|').replace(re, '\\$1');;

   	var counter=1;
   	var y,m,d;
   	var a,h,min;
   	var shortLabel=false;

   	pattern = pattern.replace(/([.*+?^<>=!:${}()|[\]\/\\])/g, '\\$1');
   	pattern = pattern.replace(/(y+|M+|d+|a|H{1,2}|h{1,2}|m{2})/g,
   		function($1) {
   			switch ($1) {
   	            case 'y'  :
   	            case 'yy' : y=counter; counter++; return '(\\d{2})';
   	            case 'MM' : m=counter; counter++; return '(\\d{2})';
   	            case 'M'  : m=counter; counter++; return '(\\d{1,2})';
   	            case 'd'  : d=counter; counter++; return '(\\d{1,2})';
   	            case 'MMM': m=counter; counter++; shortLabel=true; return '('+monthNamesShortStr+')';
   	            case 'a'  : a=counter; counter++; return '(AM|am|PM|pm)?';
   	            case 'HH' :
   	            case 'hh' : h=counter; counter++; return '(\\d{2})?';
   	            case 'H'  :
   	            case 'h'  : h=counter; counter++; return '(\\d{1,2})?';
   	            case 'mm' : min=counter; counter++; return '(\\d{2})?';
   			}
   	        // y+,M+,d+
   			var ch = $1.charAt(0);
   			if (ch=='y') {y=counter; counter++; return '(\\d{3,4})'};
   			if (ch=='M') {m=counter; counter++; return '('+monthNamesStr+')'};
   			if (ch=='d') {d=counter; counter++; return '(\\d{2})'};
   		}
   	);

   	var re = new RegExp(pattern,'i');
   	var match = dateString.match(re);
   	if (match!=null)
   	{
   		var yy = parseInt(match[y],10); if (isNaN(yy)) return null; else if (yy<70) yy+=2000; else if (yy<100) yy+=1900;
   		var mm = parseInt(match[m],10); if (isNaN(mm)) mm = this.getMonthByLabel(match[m], shortLabel ? this.monthLabelsShort : this.monthLabels); else if (--mm<0 || mm>11) return null;
   		var dd = parseInt(match[d],10); if (isNaN(dd) || dd<1 || dd>this.daysInMonth(yy, mm)) return null;

   		// time parsing
   		if (min!=undefined && h!=undefined)
   		{			
   			var hh,mmin,aa;
   			mmin = parseInt(match[min],10); if (isNaN(mmin) || mmin<0 || mmin>59) return null;
   			hh = parseInt(match[h],10); if (isNaN(hh)) return null;
   			if (a!=undefined)
   			{
   				aa = match[a].toLowerCase();
   				if ((aa!='am' && aa!='pm') || hh<1 || hh>12) return null;
   				if (aa=='pm')
   				{
   					if (hh!=12) hh+=12;
   				} else if (hh==12) hh = 0;
   			}
   			else if (hh<0 || hh>23) return null;

   			return new Date(yy, mm, dd, hh, mmin, 0);
   		}

   		return new Date(yy, mm, dd);
   	}
   	return null;   
   }, 
   
   formatDate: function (date, pattern) {
      // Copied from richfaces calendar.js
      var monthLabelsShort = this.monthLabelsShort;
      var monthLabes = this.monthLabels;
      var mm; var dd; var hh; var min;
      var result = pattern.replace(/(\\\\|\\[yMdaHhm])|(y+|M+|d+|a|H{1,2}|h{1,2}|m{2})/g,
         function($1,$2,$3) {
            if ($2) return $2.charAt(1);
   	      switch ($3) {
   	            case 'y':
   	            case 'yy':  return date.getYear().toString().slice(-2);
   	            case 'M':   return (date.getMonth()+1);
   	            case 'MM':  return ((mm = date.getMonth()+1)<10 ? '0'+mm : mm);
   	            case 'MMM': return monthLabelsShort[date.getMonth()];
   		         case 'd':   return date.getDate();
   	            case 'a'  : return (date.getHours()<12 ? 'AM' : 'PM');
   	            case 'HH' : return ((hh = date.getHours())<10 ? '0'+hh : hh);
   	            case 'H'  : return date.getHours();
   	            case 'hh' : return ((hh = date.getHours())==0 ? '12' : (hh<10 ? '0'+hh : (hh>21 ? hh-12 : (hh>12) ? '0'+(hh-12) : hh)));
   	            case 'h'  : return ((hh = date.getHours())==0 ? '12' : (hh>12 ? hh-12 : hh));
   	            case 'mm' : return ((min = date.getMinutes())<10 ? '0'+min : min);
   			}
   	        // y+,M+,d+
   			var ch = $3.charAt(0);
   			if (ch=='y') return date.getFullYear();
   			if (ch=='M') return monthLabels[date.getMonth()];
   			if (ch=='d') return ((dd = date.getDate())<10 ? '0'+dd : dd);
   		}
   	);
   	return result;
   },
   
   eventOnCollapse: function (e) {
      
      if (this.skipEventOnCollapse) {
         this.skipEventOnCollapse = false;
         return true;
      }
      
      if (e.element().id == (this.wrapperId + 'ImageBtn' ) ||
          e.element().id == this.inputId) {
         return true;
      }
      
      if ($(this.wrapperId + 'DatePicker') != undefined) {
         element = $(this.wrapperId + 'DatePicker');
         if (Position.within(element, Event.pointerX(e), Event.pointerY(e))) {
            return true;
         }
      }
      
      this.hideCalendar();
      
      return true;
   },
   
   showCalendar: function (e) {
      
      this.skipEventOnCollapse = false;
      
      if (e && e.type == 'click') {
         alert ('click');
         this.skipEventOnCollapse = true;
      }
      
      this.generateHtml();
      
      var offset = Element.positionedOffset (this.bindInput);
      var width = Element.getWidth (this.bindInput);
      var height = Element.getHeight (this.bindInput);
      
      this.calendarHtml.setStyle ( {top:(offset[1] + height)+ 'px', left:(offset[0] + width - 145)+ 'px', border: '1px solid black'});
      
      Element.show(this.calendarHtml);
      this.visible = true;
      
      Event.observe(window.document, "click", this.eventOnCollapse);
   },
   
   hideCalendar: function () {
      
      Event.stopObserving(window.document, "click", this.eventOnCollapse);
      
      Element.hide(this.calendarHtml);
      this.visible = false
   },
   
   toggle: function (e) {
      this.visible ? this.hideCalendar() : this.showCalendar(e);
   },
   
   clean: function () {
     this.bindInput.value = '';
     this.selectedDate = this.currentDate = new Date();
   },
   
   setSelectedDate: function (date) {
      this.selectedDate = new Date(date); 
      this.bindInput.value = this.formatDate(this.selectedDate, this.datePattern);
      this.currentDate = this.selectedDate;
      this.generateHtml();
   },
   
   updateYear: function (increment) {
      this.currentDate.setFullYear (this.currentDate.getFullYear() + increment);
      this.generateHtml();
   },
   
   updateMonth: function (increment) {
      this.currentDate.setMonth (this.currentDate.getMonth() + increment);
      this.generateHtml();
   },
   
   generateHtml: function () {
      
      var firstDay = new Date(this.currentDate);
      firstDay.setDate(1);
      firstDay.setDate(1 - (7 + firstDay.getDay()) % 7);
      
      var header, calBody, footer;
      header = '<table class="calendar_header" width="160px"><tbody><tr>\n'
         + '<td onclick="' + this.instanceName +'.updateYear(-1);">&lt;&lt;</td>\n'
         + '<td onclick="' + this.instanceName +'.updateMonth(-1);">&lt;</td>\n'
         + '<th>' +this.monthLabels[this.currentDate.getMonth()] + ' ' + this.currentDate.getFullYear() +'</th>\n'
         + '<td onclick="' + this.instanceName +'.updateMonth(+1);">&gt;</td>\n'
         + '<td onclick="' + this.instanceName +'.updateYear(+1);">&gt;&gt;</td>\n'
         + '</tr></tbody></table>\n';
      
      calBody = '<table class="calendar_body"><tbody><tr class="calendar_weekdays">'
      
      for (i = 0; i < 7; i++) {
         calBody += '<th>' + this.weekDayLabels [i] + '</th>'; 
      }
      
      calBody += '</tr>';
      
      var today = new Date();
      var dayScroller = new Date(firstDay);
      while ( dayScroller.getMonth() == this.currentDate.getMonth() ||
              dayScroller.getMonth() == firstDay.getMonth() ) {
         
         calBody += '<tr>';
         
         for (i = 0; i < 7; i++) {
            
            classes = [];
            
            if (dayScroller.getMonth() != this.currentDate.getMonth())
               classes[classes.length] = 'othermonth';
            
            if (dayScroller.getDay() == 0 || dayScroller.getDay() == 6)
               classes[classes.length] = 'weekend';
               
            if (Math.floor (dayScroller.valueOf() / 8.64e7) == Math.floor (today.valueOf() / 8.64e7))
               classes[classes.length] = 'today';
            
            if (Math.floor (dayScroller.valueOf() / 8.64e7) == Math.floor (this.selectedDate.valueOf() / 8.64e7))
               classes[classes.length] = 'selected';
                  
            calBody += '<td onclick="' + this.instanceName +'.setSelectedDate(' + dayScroller.valueOf()  + ');' + this.instanceName +'.toggle();"' + ( classes.length ? ' class="' + classes.join(' ') +'">' : '>' ) + dayScroller.getDate() + '</td>\n'
            dayScroller.setDate(dayScroller.getDate() + 1);
         }
         
         calBody += '</tr>';
         
      }
      
      calBody += '</tbody></table>'
      
      footer = '<table class="calendar_footer"><tbody><tr><td onclick="' + this.instanceName +'.setSelectedDate(' + today.valueOf()  + ');">' + this.todayLabel+ '</td>'
         + '<td onclick="' + this.instanceName +'.clean();">'+ this.cleanLabel +'</td>'
         + '<td onclick="' + this.instanceName +'.toggle();">'+ this.closeLabel +'</td></tr></tbody></table>'
      
      this.calendarHtml.innerHTML = header + calBody + footer;
   
   }

});